// logger.js
const winston = require('winston');
const path = require('path');


const { combine, timestamp, printf, colorize } = winston.format;

// Define custom format for log messages
const customFormat = printf(({ level, message, timestamp }) => {
  return `${timestamp} [${level.toUpperCase()}]: ${message}`;
});

const logger = winston.createLogger({
  level: 'info',
  format: combine(
    timestamp(), // Add timestamp to log messages
    customFormat // Apply custom format
  ),
  transports: [
    // Log to console with colors
    new winston.transports.Console({
      format: combine(
        colorize(),
        timestamp(),
        customFormat
      )
    }),
    // Log to file
    new winston.transports.File({ 
      filename: path.join(__dirname, '../../combined.log'),
      maxsize: 10485760, // 10MB
      maxFiles: 5
    })
  ]
});

module.exports = logger;
