const mongoose = require("mongoose");
const Counter = require("../models/counter.js");

//console.log(mongoURI);
// Options for the connection

const connectDB = async (mongoURI, dbName) => {
  const options = {
    dbName: dbName,
  };
  try {
    const conn = await mongoose.connect(mongoURI, options);
    console.log(
      `MongoDB Connected: ${conn.connection.host} Database:${dbName}`
    );

    // Call the initialization function
    initializeCounter().catch((err) => console.error(err));
  } catch (error) {
    console.error(`Error: ${error.message}`);
    process.exit(1);
  }
};

// Initialize the counter document
const initializeCounter = async () => {
  const counterExists = await Counter.findOne({ name: "nominationIndex" });
  if (!counterExists) {
    await new Counter({ name: "nominationIndex", seq: 0 }).save();
  }
};

module.exports = { connectDB };
