const { connectDB } = require('./db.js');
const { dbName, mongoURI } = require('../env.js');
const { event_profile } = require("../models/config.js");

// Connect to MongoDB
connectDB(mongoURI, dbName);

const defaultProfile = {
  "_id": {
    "$oid": "6657bae53a86d4bf4fa8f12b"
  },
  "name": "Sentient Dinner And Awards Night",
  "picture": "https://iili.io/JLLQsLv.jpg",
  "logo": "https://iili.io/JLLQsLv.jpg",
  "code_prefix": "STDA",
  "rate": 0.5,
  "income": 0.9,
  "nominations": true,
  "key": "dorcas_seshie",
  "__v": 0
};

async function loadConfig() {
  try {
    const profile = await event_profile.findOne();
    if (!profile) {
      console.log('Profile not found, using default profile');
      return defaultProfile;
    }
    return {
      ...profile._doc,
    };
  } catch (error) {
    console.error('Error loading config:', error);
    return defaultProfile;
  }
}

module.exports = { loadConfig };
