const { event_profile } = require("../models/config.js");

// Load config from database
const getConfig = async () => {
  try {
    const profile = await event_profile.findOne();
    return profile || null;
  } catch (error) {
    console.error("Error loading config from database:", error);
    return null;
  }
};

// Connecting to the database
const validKey = process.env.keyy;

module.exports = {
  getConfig,
  validKey
};
