const { Vote } = require("../models/vote.js");
const { Category } = require("../models/category.js");
const { event_profile } = require("../models/config.js");

const analytics = async () => {
  try {
    const categories = await Category.countDocuments({}).exec();
    const totalVotes = await Vote.countDocuments({}).exec();
    const profile = await event_profile.findOne();

    // Get unique voters by their voter.contact field
    const totalVoters = await Vote.aggregate([
      { $group: { _id: "$voter.contact" } },
      { $count: "totalVoters" },
    ]).exec();

    // The result will be an array with one object like [{ totalVoters: 123 }]
    // or an empty array if there are no votes
    const count = totalVoters[0]?.totalVoters || 0;
    // Update the closingDateTTime to 10th August 2025
 

    let time_left = null;
    let time_left_breakdown = null;
    let closingDate = profile.closingDateTTime ? new Date(profile.closingDateTTime) : null;

    if (closingDate) {
      const now = new Date();
      let diff = closingDate - now;

      if (diff > 0) {
      // Calculate breakdown
      const years = Math.floor(diff / (1000 * 60 * 60 * 24 * 365));
      diff -= years * (1000 * 60 * 60 * 24 * 365);

      const days = Math.floor(diff / (1000 * 60 * 60 * 24));
      diff -= days * (1000 * 60 * 60 * 24);

      const hours = Math.floor(diff / (1000 * 60 * 60));
      diff -= hours * (1000 * 60 * 60);

      const minutes = Math.floor(diff / (1000 * 60));
      diff -= minutes * (1000 * 60);

      time_left = closingDate - now;
      time_left_breakdown = {
        years,
        days,
        hours,
        minutes,
        closingDate,
      };
      } else {
      time_left = 0;
      time_left_breakdown = {
        years: 0,
        days: 0,
        hours: 0,
        minutes: 0,
        closingDate,
      };
      }
    }
      
    return {
      categories,
      totalVotes,
      totalVoters: count,
      time_left,
      time_left_breakdown,
    };

  } catch (error) {
    console.error("Error fetching analytics:", error);
    throw new Error("Failed to fetch analytics");
  }
};

module.exports = { analytics };
