const express = require("express");
const multer = require("multer");
const { Category } = require("../models/category.js");
const { Nomination } = require("../models/nomination.js");
const { event_profile } = require("../models/config.js");
const uploadImage = require("../controllers/imageHostCOntroller.js");

const upload = multer({ storage: multer.memoryStorage() });
const nominationRoutes = express.Router();

nominationRoutes.get("/", async (req, res) => {
  const status = await event_profile.findOne();
  const event = status;
  if (status.nominations === true) {
    try {
      const categories = await Category.find();
      return res.render("nomination", { categories,event });
    } catch (error) {
      console.error("Error fetching categories:", error);
      return res.status(500).send("Server error. Please try again later.");
    }
  } else {
    return res.send(`
            <html>
            <head>
                <title>Nominations Closed</title>
                <style>
                    body {
                        font-family: Arial, sans-serif;
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        margin: 0;
                        background-color: #f0f0f0;
                    }
                    .message-container {
                        text-align: center;
                        padding: 20px;
                        background: #fff;
                        box-shadow: 0 0 10px rgba(0,0,0,0.1);
                    }
                    h1 {
                        color: #333;
                    }
                    p {
                        color: #666;
                    }
                </style>
            </head>
            <body>
                <div class="message-container">
                    <h1>Nominations Closed</h1>
                    <p>Unfortunately, nominations are currently closed. Please check back later.</p>
                </div>
            </body>
            </html>
        `);
  }
});

nominationRoutes.post("/", upload.single("file"), async (req, res) => {
  try {
    const { name, gender, Class, phone, category, Reason } = req.body;
    const exists = Nomination.find({ name: name, category: category });

    if (!req.file) {
      return res.status(400).json({ message: "No file uploaded" });
    }

    const imageUrl = await uploadImage(req.file);

    const newNomination = new Nomination({
      name,
      gender,
      Class,
      phone,
      category,
      Reason,
      imageUrl,
    });

    await newNomination.save();

    res.status(200).json({ message: "Nomination submitted successfully" });
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: "Error submitting nomination" });
  }
});

module.exports = { nominationRoutes };
