const { Category } = require("../models/category.js");
const { Router } = require("express");
const { Nomination } = require("../models/nomination.js");
const {loadConfig} = require("../utilities/config.js");
const config = loadConfig();
const categoryRoutes = Router();

categoryRoutes.get("/:cat", async (req, res) => {
  try {
    const categoryId = req.params.cat;
    const category = await Category.findById(categoryId);
    const nominations = await Nomination.find({
      category: categoryId,
      isApproved: true,
    }).exec();
    if (!category) {
      return res.status(404).send("Category not found");
    }
    const event = await config;

    res.render("categoryList", { nominations, event, category });
  } catch (error) {
    console.error("Error fetching nominations:", error);
    res.status(500).send("Internal Server Error");
  }
});

module.exports = { categoryRoutes };
