const { Schema, model } = require("mongoose");

const key = process.env.paystack_public_key;
const vsessionSchema = new Schema(
  {
    contact: {
      type: String,
      required: true,
    },
    votes: {
      type: Number,
      required: true,
    },
    nominee: {
      type: Schema.Types.ObjectId,
      ref: "Nomination",
      required: true,
    },
    category: {
      type: Schema.Types.ObjectId,
      ref: "Category",
      required: true,
    },
    reference: {
      type: String,
      required: true,
    },
    paystack_key:{
      type:String,
      required:true,
      default:`${key}`
    },
    type:{
      type:String,
      default:"siteSession"
    }
  },
  { timestamps: true }
);

const vSession = model("vSession", vsessionSchema);

module.exports = { vSession };
