// models/Vote.js

const { Schema, model } = require("mongoose");

const voteSchema = new Schema({
  voter: {
    type: Object,
    required: true,
  },
  nominee: {
    type: Schema.Types.ObjectId,
    ref: "Nomination",
    required: true,
  },
  category: {
    type: Schema.Types.ObjectId,
    ref: "Category",
    required: true,
  },
  createdAt: {
    type: Date,
    default: Date.now,
  },
  index:{
    type:Number,
    required:true,
  }
});

const Vote = model("Vote", voteSchema);

module.exports = { Vote };
