const mongoose = require("mongoose");
const  { hashPassword } = require('../utilities/encryption.js');

const userSchema = new mongoose.Schema({
    username: {
      type: String,
      required: true,
      unique: true
    },
    name:{
      type:String,
      required:true,
      unique:true
    },
    email: {
      type: String,
      required: true,
      unique: true
    },
    password: {
      type: String,
      required: true
    },
    isApproved: {
      type: Boolean,
      default: false
    },
    isAdmin: {
      type: Boolean,
      default: false
    },
    createdAt: {
      type: Date,
      default: Date.now
    },profile_pic:{
      type:String,
      required:false,
    }
  });

userSchema.pre('save', async function (next) {
    try {
        if (this.isModified('password')) {
            this.password = await hashPassword(this.password);
        }
        next();
    } catch (error) {
        next(error);
    }
});

const User = mongoose.model('User', userSchema);

module.exports = { User };
