const mongoose = require("mongoose");

const profile =  new mongoose.Schema({
    name:{
        type:String,
        required:true
    },
    picture:{
        type:String,
        required:false,
    },
    logo:{
        type:String,
        required:false,
    },
    code_prefix:{
        type:String,
        required:true
    },
    rate:{
        type:Number,
        required:true,
    },
    income:{
        type:Number,
        required:true,
    },
    nominations:{
        type:Boolean,
        default:false
    },
    voting:{
        type:Boolean,
        default:false
    },
    key:{
        type:String,
        required:true
    },
        public_viewing:{
        type:Boolean,
        default:false
    },
    closingDateTTime:{
        type:Date,
        required:true
    },
})

const event_profile = mongoose.model('Profile', profile);

module.exports = { event_profile };
