const mongoose = require('mongoose');
const {loadConfig} = require('../utilities/config.js');
const Counter = require('./counter.js');

const nominationSchema = new mongoose.Schema({
    code: {
        type: String,
        unique: true,
        maxlength: 5
    },
    name: {
        type: String,
        required: true
    },
    gender: {
        type: String,
        enum: ['Male', 'Female'],
        required: true
    },
    Class: {
        type: Number,
        required: true
    },
    phone: {
        type: String,
        required: true
    },
    category: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Category',
        required: true
    },
    Reason: {
        type: String,
        required: false
    },
    imageUrl: {
        type: String,
        required: true
    },
    isApproved: {
        type: Boolean,
        default: false
    }
}, {
    timestamps: true
});

nominationSchema.pre('save', async function(next) {
    try {
        const config = await loadConfig();
        const prefix = config.code_prefix;

        // Find and update the counter document atomically
        const counter = await Counter.findOneAndUpdate(
            { name: 'nominationIndex' },
            { $inc: { seq: 1 } },
            { new: true, upsert: true } // Create the document if it doesn't exist
        );

        // Generate the code using the updated sequence
        const nextIndex = counter.seq.toString().padStart(3, '0');
        this.code = prefix + nextIndex;

        next();
    } catch (error) {
        next(error);
    }
});

const Nomination = mongoose.model('Nomination', nominationSchema);

module.exports = { Nomination };
