document.getElementById("updateForm").addEventListener("submit", async function(event) {
    event.preventDefault();
    
    const formData = new FormData(this);
    
    try {
        const response = await fetch('/u/update', {
            method: 'POST',
            body: formData
        });

        const result = await response.json();
        if (response.ok) {
            alert("Update successful!");
        } else {
            alert("Update failed: " + result.message);
        }
    } catch (error) {
        console.error("Error:", error);
        alert("An error occurred while updating your profile.");
    }
});
