document.addEventListener('DOMContentLoaded', () => {
  const toggleButton = document.getElementById('toggle-btn');
  const sidebar = document.getElementById('sidebar');
  const closeButton = document.getElementById('close-btn');

  toggleButton.addEventListener('click', () => {
    sidebar.classList.toggle('visible');
  });

  closeButton.addEventListener('click', () => {
    sidebar.classList.remove('visible');
  });

  document.addEventListener('click', (event) => {
    const isClickInside = sidebar.contains(event.target) || toggleButton.contains(event.target);

    if (!isClickInside) {
      sidebar.classList.remove('visible');
    }
  });
});
