let currentStep = 1;
const totalSteps = 4;

function validateStep(stepNumber) {
  const step = document.getElementById(`step${stepNumber}`);
  const inputs = step.querySelectorAll("input[required]");

  for (let input of inputs) {
    if (!input.value.trim()) {
      input.focus();
      input.style.borderColor = "#dc3545";
      setTimeout(() => {
        input.style.borderColor = "#e1e5e9";
      }, 2000);
      return false;
    }
  }
  return true;
}

function updateStepIndicator() {
  const dots = document.querySelectorAll(".step-dot");

  dots.forEach((dot, index) => {
    dot.classList.remove("active", "completed");
    if (index + 1 < currentStep) {
      dot.classList.add("completed");
    } else if (index + 1 === currentStep) {
      dot.classList.add("active");
    }
  });
}

function showStep(stepNumber) {
  // Hide all steps
  document.querySelectorAll(".step").forEach((step) => {
    step.classList.remove("active");
  });

  // Show current step
  document.getElementById(`step${stepNumber}`).classList.add("active");

  // Update step indicator
  updateStepIndicator();
}

function nextStep() {
  if (validateStep(currentStep)) {
    if (currentStep < totalSteps) {
      currentStep++;
      showStep(currentStep);
    }
  }
}

function prevStep() {
  if (currentStep > 1) {
    currentStep--;
    showStep(currentStep);
  }
}

function showReview() {
  if (validateStep(currentStep)) {
    document.getElementById("submitBtn").style.display = "block";

    // Optional: Show a summary of all entered data
    const messageDiv = document.getElementById("message");
    messageDiv.style.color = "#667eea";
    messageDiv.style.borderColor = "#667eea";
    messageDiv.innerHTML =
      "<strong>Ready to submit!</strong> Please review your information and click Submit Configuration.";
  }
}

document
  .getElementById("configForm")
  .addEventListener("submit", async function (e) {
    e.preventDefault();
    const form = e.target;
    const messageDiv = document.getElementById("message");

    // Add loading state
    form.classList.add("loading");

    const data = {
      name: form.name.value,
      picture: form.picture.value,
      logo: form.logo.value,
      code_prefix: form.code_prefix.value,
      rate: form.rate.value,
      keyy: form.keyy.value,
      income: parseFloat(form.income.value) / 100, // Convert percentage to decimal
      closingDateTTime: form.closingDateTTime.value,
    };

    messageDiv.textContent = "Submitting...";
    messageDiv.style.color = "#667eea";
    messageDiv.style.borderColor = "#667eea";

    try {
      const res = await fetch(`/config/ust_polls`, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(data),
      });
      const result = await res.json();

      // Remove loading state
      form.classList.remove("loading");

      if (result.success) {
        messageDiv.style.color = "#28a745";
        messageDiv.style.borderColor = "#28a745";
        messageDiv.innerHTML = "<strong>Success!</strong> " + result.message;

        // Reset form and go back to step 1
        setTimeout(() => {
          window.location.href = "/";
        }, 3000);
      } else {
        messageDiv.style.color = "#dc3545";
        messageDiv.style.borderColor = "#dc3545";
        messageDiv.innerHTML =
          "<strong>Error:</strong> " + (result.message || "Error occurred");
      }
    } catch (err) {
      // Remove loading state
      form.classList.remove("loading");
      messageDiv.style.color = "#dc3545";
      messageDiv.style.borderColor = "#dc3545";
      messageDiv.innerHTML =
        "<strong>Network Error:</strong> Unable to connect to server";
    }
  });

// Add keyboard navigation
document.addEventListener("keydown", function (e) {
  if (e.key === "Enter" && !e.target.matches("button")) {
    e.preventDefault();
    if (currentStep < totalSteps) {
      nextStep();
    } else if (document.getElementById("submitBtn").style.display === "block") {
      document.getElementById("configForm").dispatchEvent(new Event("submit"));
    }
  }
});
