document.addEventListener("DOMContentLoaded", () => {
  const searchIcon = document.getElementById("search-icon");
  searchIcon.addEventListener("click", () => {
    document.body.classList.toggle("show-search");
    // Optionally focus input when shown
    if(document.body.classList.contains("show-search")) {
      document.getElementById("search-input").focus();
    }
  });
  const searchInput = document.getElementById("search-input");
  const searchResults = document.getElementById("search-results");
  const searchLoader = document.getElementById("search-loader");

  searchInput.addEventListener("input", async () => {
    const query = searchInput.value.trim();

    if (query.length === 0) {
      searchResults.innerHTML = "";
      searchResults.classList.remove('show');
      return;
    }
    if(query.length > 0){
      searchResults.classList.add('show');
    }
    searchLoader.style.display = "block";
    searchResults.innerHTML = "";

    try {
      const response = await fetch(`/search?query=${encodeURIComponent(query)}`);
      const data = await response.json();

      searchLoader.style.display = "none";

      if (response.ok) {
        displayResults(data);
      } else {
        searchResults.innerHTML = `<p class='no-results'>${data.message}</p>`;
      }
    } catch (error) {
      console.error("Search error:", error);
      searchResults.innerHTML = "<p class='error-message'>Error fetching results</p>";
      searchLoader.style.display = "none";
    }
  });

  function displayResults(results) {
    searchResults.innerHTML = results.map(nominee => `
      <div class='search-item'>
        <a href="/vote/${nominee._id}">
          <strong>${nominee.name}</strong> (${nominee.code})
        </a>
      </div>
    `).join("");
  }
});
