// Get the popup message element
var popup = document.getElementById("popupMessage");

// Show popup message
function showPopup(message, isSuccess) {
  popup.textContent = message;
  popup.className = "popup " + (isSuccess ? "success" : "error");
  popup.style.display = "block";

  // Hide the popup after 3 seconds
  setTimeout(() => {
    popup.style.display = "none";
  }, 3000);
}

const paymentForm = document.getElementById("paymentForm");
paymentForm.addEventListener("submit", payWithPaystack, false);
const MAX_VOTES = 5000; // Maximum number of votes allowed

async function payWithPaystack(e) {
  e.preventDefault();

  // Retrieve input values
  const phone = document.getElementById("phoneNumber").value;
  const votes = document.getElementById("voteNumber").value;
  const code = document.getElementById("candidate_id").textContent.trim();
  const category = document.getElementById("category_id").textContent.trim();
  const nominee_code =   document.getElementById("code").textContent.trim();

  // Validate number of votes
  if (votes > MAX_VOTES) {
    showPopup("Maximum number of votes allowed is 5000.", false);
    return;
  }

  // Retrieve key
  const pubkey = document.getElementById("paystack_public_key").textContent;

  // Calculate amount based on rate and number of votes
  const rate = document.getElementById("rate").textContent;
  const amount = votes * rate * 100;

  let hostname = window.location.hostname;
  if (!hostname.endsWith(".com")) {
    hostname += ".com";
  }
  const email = `${phone}@${hostname}`;

  // Generate a pseudo-unique reference
  const now = new Date();
  const year = now.getFullYear().toString().slice(-2); // Last 2 digits of year
  const month = ("0" + (now.getMonth() + 1)).slice(-2); // 2 digits month
  const day = ("0" + now.getDate()).slice(-2); // 2 digits day
  const time = now.getTime().toString().slice(-4); // Last 4 digits of time
  const phoneSuffix = phone.slice(-4); // Last 4 digits of phone
  const ref = nominee_code + year + month + day + time + phoneSuffix;

  const sessionBody = {
    contact: phone,
    votes: votes,
    code: code,
    category: category,
    reference: ref,
  };

  await createSession(sessionBody);

  // Initialize Paystack handler
  let handler = PaystackPop.setup({
    key: pubkey.trim(),
    email: email,
    amount: amount,
    currency: "GHS",
    ref: ref,
    onClose: function () {
      showPopup("Window closed.", true);
    },
    callback: function (response) {
      let message = "Payment complete! Reference: " + response.reference;
      if (response.message === "Approved") {
        //nothing happens
        showPopup("Your vote has been cast", true);
        setTimeout(()=>{
          location.reload()
        },1700)
      } else {
        // Tell the server what happened to the payment response and send the response over
        try {
          fetch("/vote/case", {
            method: "POST",
            headers: {
              "Content-Type": "application/json",
            },
            body: JSON.stringify(response),
          });
        } catch (error) {
          // Handle fetch error
          console.error("Error sending case information:", error);
        }
      }
      showPopup(message, true);
    },
  });

  // Open Paystack iframe for payment
  handler.openIframe();
}

async function createSession(session) {
  try {
    const response = await fetch("/vote/session", {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify(session),
    });

    if (!response.ok) {
      const errorData = await response.json();
      throw new Error(
        errorData.message || "An error occurred while creating the session."
      );
    }

    const responseData = await response.json();
    console.log(responseData);
    return responseData;
  } catch (error) {
    console.error("Failed to create session:", error.message);
    // Handle the error appropriately in your UI
    showPopup(error.message, false);
    setTimeout(() => {
      //location.reload();
    }, 3000);
  }
}
