var modalNominee = document.getElementById("nomineeModal");
var spanNominee = modalNominee.getElementsByClassName("close")[0];
var openNomineeBtn = document.getElementById("openNomineeModalBtn");

var modalNomineeProfile = document.getElementById("nominee-profile-modal");
var spanNomineeProfile = modalNomineeProfile.getElementsByClassName("close")[0];


// Get the popup message element
var popup = document.getElementById("popupMessage");

openNomineeBtn.onclick = function () {
  modalNominee.style.display = "block";
};


spanNominee.onclick = function () {
  modalNominee.style.display = "none";
};

spanNomineeProfile.onclick = function () {
  modalNomineeProfile.style.display = "none";
};

window.onclick = function (event) {
  if (event.target == modalNominee) {
    modalNominee.style.display = "none";
  }

};

// Show popup message
function showPopup(message, isSuccess) {
  popup.textContent = message;
  popup.className = "popup " + (isSuccess ? "success" : "error");
  popup.style.display = "block";

  // Hide the popup after 3 seconds
  setTimeout(() => {
    popup.style.display = "none";
  }, 3000);
}
var nominees;

window.onload = function () {
  fetch("/admin/nominees")
    .then((response) => response.json())
    .then((data) => {
     // console.log(data)
      nominees = data.nominees;
      nominees.forEach((nominee) => {
        var li = document.createElement("li");
        li.setAttribute("id", nominee._id);
        li.setAttribute("class", "nominee-list");

        var nameSpan = document.createElement("span");
        nameSpan.classList.add("nominee-name");
        nameSpan.textContent = nominee.name;

        var categorySpan = document.createElement("span");
        categorySpan.classList.add("nominee-category");
        categorySpan.textContent = nominee.category;
    
        var codeSpan = document.createElement("span");
        codeSpan.classList.add("nominee-code");
        codeSpan.textContent = nominee.code;

        var statusIcon = document.createElement("i");
        statusIcon.classList.add("fas");

        if (nominee.isApproved) {
          statusIcon.classList.add("fa-check", "approved");
        } else {
          statusIcon.classList.add("fa-times", "not-approved");
        }

        li.appendChild(nameSpan);
        li.appendChild(codeSpan);
        li.appendChild(categorySpan);
        li.appendChild(statusIcon);

        li.addEventListener("click", function () {
          fillModal(nominee);
        });

        document.getElementById("nomineeList").appendChild(li);
      });
    })
    .catch((error) => console.error("Error:", error));
};


function fillModal(nominee) {
  var modal = document.getElementById("nominee-profile-modal");
  var profileDiv = modal.querySelector(".nomineeprofile");
  profileDiv.innerHTML = `
      <div>
            <img src="${nominee.imageUrl}" alt="${nominee.name}" class="nominee-image">
      </div>
      <div class="nomineeprofile-box">
        <h1>${nominee.name}</h1>
        <p>Gender: ${nominee.gender}</p>
        <p>Class: ${nominee.Class}</p>
        <p>Phone: ${nominee.phone}</p>
        <p>Code: ${nominee.code}</p>
        <p>Category: ${nominee.category}</p>
        <p>Reason: ${nominee.Reason}</p>
        <p>Approved:${nominee.isApproved}</p>
      </div>
        
    `;

  document.getElementById("approveBtn").onclick = function () {
    updateApprovalStatus(nominee._id, "approve");
  };

  document.getElementById("disapproveBtn").onclick = function () {
    updateApprovalStatus(nominee._id, "disapprove");
  };
  document.getElementById("deleteBtn").onclick = function (){
    updateApprovalStatus(nominee._id,"purge");
  }

  modal.style.display = "block";
}

function updateApprovalStatus(nomineeId, state) {
  fetch(`/admin/nominee_approval/${state}`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify({ nominee: nomineeId }),
  })
    .then((response) => response.json())
    .then((data) => {
      showPopup(data.message, data.status === "success");

      setTimeout(() => {
        window.location.reload();
      }, 1500);
    })
    .catch((error) => {
      console.error("Error:", error);
      showPopup("Unexpected response from server", false);
    });
}
