document.addEventListener("DOMContentLoaded", function () {
  const popup = document.getElementById("popupMessage");
  const submitButton = document.getElementById("submit");

  function showPopup(message, isSuccess) {
    popup.textContent = message;
    popup.className = "popup " + (isSuccess ? "success" : "error");
    popup.style.display = "block";

    setTimeout(() => {
      popup.style.display = "none";
    }, 3000);
  }

  submitButton.onclick = async function (event) {
    event.preventDefault();
    submitButton.style.display = "none";

    const formData = new FormData();
    formData.append("file", document.getElementById("file").files[0]);
    formData.append("name", document.querySelector('input[name="name"]').value);
    formData.append("gender", document.querySelector('input[name="gender"]:checked').value);
    formData.append("Class", document.getElementById("Class").value);
    formData.append("phone", document.getElementById("phone").value);
    formData.append("category", document.getElementById("category").value);
    formData.append("Reason", document.querySelector('input[name="Reason"]').value);

    try {
      const response = await fetch("/nominations", {
        method: "POST",
        body: formData,
      });

      const result = await response.json();
      if (response.ok) {
        showPopup("Nomination submitted successfully", true);
        setTimeout(() => {
          window.location.reload();
        }, 1500);
      } else {
        showPopup(result.message || "Error submitting nomination", false);
        submitButton.style.display = "";
      }
    } catch (error) {
      console.error("Error:", error);
      showPopup("Error submitting nomination", false);
      submitButton.style.display = "";
    }
  };
});
