document.addEventListener("DOMContentLoaded", function() {
  const nominationSwitch = document.getElementById("nominationSwitch");
  const votingSwitch = document.getElementById("votingSwitch");
  const resultSwitch = document.getElementById("resultSwitch");

  const nominationStatusElem = document.getElementById("nomination-status");
  const votingStatusElem = document.getElementById("voting-status");
  const resultStatusElem = document.getElementById("result-status");


  // Retrieve initial status from hidden elements
  const nominationStatus = nominationStatusElem.innerHTML.trim() === "true";
  const votingStatus = votingStatusElem.innerHTML.trim() === "true";
  const resultStatus = resultStatusElem.innerHTML.trim() === "true";

  // Initialize switches based on initial status
  nominationSwitch.checked = nominationStatus;
  votingSwitch.checked = votingStatus;
  resultSwitch.checked = resultStatus;

  // Function to handle status update
  const handleStatusUpdate = async (endpoint, status, switchElement, successMessage) => {
    try {
      const response = await fetch(`/admin/${endpoint}/${status}`, {
        method: "POST",
        headers: {
          "Content-Type": "application/json"
        }
      });
      let out = await response.json()
      
      
      if (!response.ok) {

        throw new Error(`Failed to update ${endpoint} status: ${response.statusText}`);
      } else if(out.status == true) {
        console.log(`${successMessage} to ${out.status}`);
        // this.location.reload()
      }
    } catch (error) {
      console.error(`Error updating ${endpoint} status: ${error}`);
      switchElement.checked = !switchElement.checked; // Revert state if error
    }
  };

  // Handle nomination switch toggle
  nominationSwitch.addEventListener("change", function() {
    const status = nominationSwitch.checked ? "true" : "false";
    handleStatusUpdate("nomination", status, nominationSwitch, "Nomination status updated successfully");
  });

  // Handle voting switch toggle
  votingSwitch.addEventListener("change", function() {
    const status = votingSwitch.checked ? "true" : "false";
    handleStatusUpdate("voting", status, votingSwitch, "Voting status updated successfully");
  });

  // Handle result switch toggle
  resultSwitch.addEventListener("change", function() {
    const status = resultSwitch.checked ? "true" : "false";
    handleStatusUpdate("vote_results", status, resultSwitch, "Result status updated successfully");
  });
});