// Dashboard charts and progress bars for results page
// Requires Chart.js to be loaded in the HTML

document.addEventListener("DOMContentLoaded", function() {
  // Pie chart for candidate votes
  const chartCanvas = document.getElementById('votes-pie-chart');
  if (chartCanvas) {
    const candidateNames = JSON.parse(chartCanvas.getAttribute('data-names'));
    const candidateVotes = JSON.parse(chartCanvas.getAttribute('data-votes'));
    const pieColors = [
      '#22baa0', '#f6d433', '#11a8c3', '#f25656', '#1B3764', '#B0B0B0', '#7c3aed', '#f472b6', '#38bdf8', '#facc15'
    ];
    new Chart(chartCanvas, {
      type: 'pie',
      data: {
        labels: candidateNames,
        datasets: [{
          data: candidateVotes,
          backgroundColor: pieColors
        }]
      },
      options: {
        responsive: true,
        plugins: {
          legend: {
            display: false // Hide default legend
          }
        }
      }
    });
    // Render custom legend
    const legendContainer = document.getElementById('votes-pie-legend');
    if (legendContainer) {
      legendContainer.innerHTML = candidateNames.map((name, idx) => `
        <div class="legend-item">
          <span class="legend-color" style="background:${pieColors[idx % pieColors.length]}"></span>
          <span class="legend-label">${name}</span>
        </div>
      `).join('');
    }
  }

  // Line chart for candidate votes
  const lineChartCanvas = document.getElementById('votes-line-chart');
  if (lineChartCanvas) {
    const candidateNames = JSON.parse(lineChartCanvas.getAttribute('data-names'));
    const candidateVotes = JSON.parse(lineChartCanvas.getAttribute('data-votes'));
    new Chart(lineChartCanvas, {
      type: 'line',
      data: {
        labels: candidateNames,
        datasets: [{
          label: 'Votes',
          data: candidateVotes,
          fill: true,
          borderColor: '#1B3764',
          backgroundColor: 'rgba(34,186,160,0.07)',
          pointBackgroundColor: '#f6d433',
          pointBorderColor: '#1B3764',
          tension: 0.35,
        }]
      },
      options: {
        responsive: true,
        plugins: {
          legend: {
            display: false
          },
          tooltip: {
            mode: 'index',
            intersect: false
          }
        },
        scales: {
          x: {
            ticks: { color: '#1B3764', font: { size: 13, weight: 'bold' } },
            grid: { display: false }
          },
          y: {
            beginAtZero: true,
            ticks: { color: '#1B3764', font: { size: 13 } },
            grid: { color: '#e9edf2' }
          }
        }
      }
    });
  }

  // Progress bars for each candidate
  const progressBars = document.querySelectorAll('.candidate-progress-bar');
  progressBars.forEach(function(bar) {
    const percent = +bar.getAttribute('data-percent');
    bar.style.width = percent + '%';
    if (percent >= 90) {
      bar.style.background = '#22baa0';
    } else if (percent >= 70) {
      bar.style.background = '#11a8c3';
    } else if (percent >= 50) {
      bar.style.background = '#f6d433';
    } else {
      bar.style.background = '#f25656';
    }
  });
});
