var modal = document.getElementById("categoryModal");
var popup = document.getElementById("popupMessage");
var btn = document.getElementById("openModalBtn");
var span = document.getElementsByClassName("close")[0];

btn.onclick = function () {
  modal.style.display = "block";
};

span.onclick = function () {
  modal.style.display = "none";
};

window.onclick = function (event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
};

function showPopup(message, isSuccess) {
  popup.textContent = message;
  popup.className = "popup " + (isSuccess ? "success" : "error");
  popup.style.display = "block";

  setTimeout(() => {
    popup.style.display = "none";
  }, 3000);
}

document.getElementById("categoryForm").onsubmit = function (event) {
  event.preventDefault();
  var category = document.getElementById("category").value;
  var object = { name: category };

  fetch("/admin/category", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify(object),
  })
    .then((response) => response.json())
    .then((data) => {
      console.log(data);
      document.getElementById("category").value = "";
      if (data[0]) {
        showPopup(data[0].message, data[0].status === "success");
      } else {
        showPopup("Unexpected response from server", false);
      }
    })
    .catch((error) => {
      console.error("Error:", error);
      showPopup("Error submitting category", false);
    });

  modal.style.display = "none";
  setTimeout(() => {
    window.location.reload();
  }, 1500);
};


var categoriesModal = document.getElementById("categories-modal");
var viewCategoriesBtn = document.getElementById("viewCategoriesBtn");
var categoriesList = document.getElementById("categoriesList");
var closeCategoriesModal = categoriesModal.getElementsByClassName("close")[0];

viewCategoriesBtn.onclick = function () {
  categoriesModal.style.display = "block";

};

closeCategoriesModal.onclick = function () {
  categoriesModal.style.display = "none";
};

window.onclick = function (event) {
  if (event.target == categoriesModal) {
    categoriesModal.style.display = "none";
  }
};

// Add event listeners to delete buttons
var deleteButtons = document.getElementsByClassName("delete-category-btn");
Array.from(deleteButtons).forEach(button => {
  button.onclick = function () {
    var categoryId = this.getAttribute("data-id");
    console.log(categoryId);
    deleteCategory(categoryId);
  };
});


function deleteCategory(categoryId) {
fetch(`/admin/category/${categoryId}`, {
  method: "DELETE",
  headers: {
    "Content-Type": "application/json",
  },
})
  .then((response) => response.json())
  .then((data) => {
    //console.log(data);
    // Show popup message
    if (data) {
      showPopup(data, data.status === "success");
    } else {
       showPopup("Unexpected response from server", false);
     }
    // Reload categories list
    setTimeout(()=>{
      window.location.reload();
    },1500)
    
  })
  .catch((error) => {
    console.error("Error:", error);

    showPopup("Error deleting category", false);

  });
}